/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.algorithm;

import com.fuwenchao.algorithm.AVLNode;
import com.fuwenchao.algorithm.BalanceFactor;

public class AVLTree2<E extends Comparable<E>> {
    private AVLNode<E> root = null;
    public boolean isTaller = false;

    public boolean insert(E key) {
        System.out.print("\u63d2\u5165[" + key + "]\uff1a");
        if (key == null) {
            return false;
        }
        if (this.root == null) {
            System.out.println("\u63d2\u5165\u5230\u6811\u6839\u3002");
            this.root = new AVLNode<E>(key);
            return true;
        }
        System.out.print("\u641c\u7d22\u8def\u5f84[");
        return this.insertAVL(key, this.root);
    }

    private boolean insertAVL(E key, AVLNode<E> node) {
        System.out.print(node.key + " \u2014>");
        if (node.key.compareTo(key) == 0) {
            System.out.println("].  \u641c\u7d22\u6709\u76f8\u540c\u5173\u952e\u5b57\uff0c\u63d2\u5165\u5931\u8d25");
            this.isTaller = false;
            return false;
        }
        if (node.key.compareTo(key) > 0) {
            if (node.lchild == null) {
                System.out.println("].  \u63d2\u5165\u5230" + node.key + "\u7684\u5de6\u5b69\u5b50");
                AVLNode<E> newNode = new AVLNode<E>(key);
                node.lchild = newNode;
                newNode.parent = node;
                this.isTaller = true;
            } else {
                this.insertAVL(key, node.lchild);
            }
            if (this.isTaller) {
                System.out.print("          \u6811\u53d8\u5316\u4e86\uff0c" + node.key + "\u7684\u5e73\u8861\u56e0\u5b50\u53d8\u5316");
                switch (node.bFactor) {
                    case LH: {
                        System.out.println("[LH=1 \u2014\u2014> LH=2]. \u51fa\u73b0\u4e86\u4e0d\u5e73\u8861\u73b0\u8c61[\u5de6\u6bd4\u53f3\u9ad82]");
                        System.out.println("          \u2605 \u4ee5" + node.key + "\u4e3a\u6839\u5c06\u6811\u8fdb\u884c\u5de6\u5e73\u8861\u5904\u7406");
                        this.leftBalance(node);
                        this.isTaller = false;
                        break;
                    }
                    case EH: {
                        System.out.println("[EH=0 \u2014\u2014> LH=1]. \u6ca1\u6709\u4e0d\u5e73\u8861\u73b0\u8c61");
                        node.bFactor = BalanceFactor.LH;
                        this.isTaller = true;
                        break;
                    }
                    case RH: {
                        System.out.println("[RH=-1 \u2014\u2014> EH=0]. \u6ca1\u6709\u4e0d\u5e73\u8861\u73b0\u8c61");
                        node.bFactor = BalanceFactor.EH;
                        this.isTaller = false;
                    }
                }
            }
        } else {
            if (node.rchild == null) {
                System.out.println("].  \u63d2\u5165\u5230" + node.key + "\u7684\u53f3\u5b69\u5b50");
                AVLNode<E> newNode = new AVLNode<E>(key);
                node.rchild = newNode;
                newNode.parent = node;
                this.isTaller = true;
            } else {
                this.insertAVL(key, node.rchild);
            }
            if (this.isTaller) {
                System.out.print("          \u6811\u53d8\u5316\u4e86\uff0c" + node.key + "\u7684\u5e73\u8861\u56e0\u5b50\u53d8\u5316");
                switch (node.bFactor) {
                    case LH: {
                        System.out.println("[LH=1 \u2014\u2014> EH=0]. \u6ca1\u6709\u4e0d\u5e73\u8861\u73b0\u8c61");
                        node.bFactor = BalanceFactor.EH;
                        this.isTaller = false;
                        break;
                    }
                    case EH: {
                        System.out.println("[EH=0 \u2014\u2014> RH=-1]. \u6ca1\u6709\u4e0d\u5e73\u8861\u73b0\u8c61");
                        node.bFactor = BalanceFactor.RH;
                        this.isTaller = true;
                        break;
                    }
                    case RH: {
                        System.out.println("[RH=-1 \u2014\u2014> RH=-2]. \u51fa\u73b0\u4e86\u4e0d\u5e73\u8861\u73b0\u8c61[\u5de6\u6bd4\u53f3\u77ee2]");
                        this.rightBalance(node);
                        this.isTaller = false;
                    }
                }
            }
        }
        return true;
    }

    private void leftBalance(AVLNode<E> node) {
        AVLNode lc = node.lchild;
        switch (lc.bFactor) {
            case LH: {
                System.out.println("           \u2516 \u5bf9" + node.key + "\u8fdb\u884c\u5355\u53f3\u65cb\u8f6c\u5904\u7406");
                node.bFactor = lc.bFactor = BalanceFactor.EH;
                this.rRotate(node);
                break;
            }
            case RH: {
                System.out.println("            \u2516 \u5bf9" + node.key + "\u7684\u5de6\u5b50\u6811\u8fdb\u884c\u5355\u5de6\u65cb\u8f6c\u5904\u7406\uff0c\u518d\u5bf9\u5176\u672c\u8eab\u6811\u8fdb\u884c\u5355\u53f3\u5faa\u73af\u5904\u7406");
                AVLNode rd = lc.rchild;
                switch (rd.bFactor) {
                    case LH: {
                        node.bFactor = BalanceFactor.RH;
                        lc.bFactor = BalanceFactor.EH;
                        break;
                    }
                    case EH: {
                        node.bFactor = lc.bFactor = BalanceFactor.EH;
                        break;
                    }
                    case RH: {
                        node.bFactor = BalanceFactor.EH;
                        lc.bFactor = BalanceFactor.LH;
                    }
                }
                rd.bFactor = BalanceFactor.EH;
                this.lRotate(node.lchild);
                this.rRotate(node);
                break;
            }
        }
    }

    private void rightBalance(AVLNode<E> node) {
        AVLNode lc = node.rchild;
        switch (lc.bFactor) {
            case RH: {
                node.bFactor = lc.bFactor = BalanceFactor.EH;
                this.lRotate(node);
                break;
            }
            case LH: {
                AVLNode rd = lc.lchild;
                switch (rd.bFactor) {
                    case LH: {
                        node.bFactor = BalanceFactor.EH;
                        lc.bFactor = BalanceFactor.RH;
                        break;
                    }
                    case EH: {
                        node.bFactor = lc.bFactor = BalanceFactor.EH;
                        break;
                    }
                    case RH: {
                        node.bFactor = BalanceFactor.LH;
                        lc.bFactor = BalanceFactor.EH;
                    }
                }
                rd.bFactor = BalanceFactor.EH;
                this.rRotate(node.rchild);
                this.lRotate(node);
                break;
            }
        }
    }

    private void rRotate(AVLNode<E> node) {
        AVLNode lc = node.lchild;
        node.lchild = lc.rchild;
        lc.rchild = node;
        if (node.parent == null) {
            this.root = lc;
        } else if (node.parent.lchild.key.compareTo(node.key) == 0) {
            node.parent.lchild = lc;
        } else {
            node.parent.rchild = lc;
        }
    }

    private void lRotate(AVLNode<E> node) {
        AVLNode rc = node.rchild;
        node.rchild = rc.lchild;
        rc.lchild = node;
        if (node.parent == null) {
            this.root = rc;
        } else if (node.parent.lchild.key.compareTo(node.key) == 0) {
            node.parent.lchild = rc;
        } else {
            node.parent.rchild = rc;
        }
    }

    public AVLNode<E> getRoot() {
        return this.root;
    }

    public void preOrderTraverse(AVLNode<E> node) {
        if (node != null) {
            System.out.println(node);
            this.preOrderTraverse(node.lchild);
            this.preOrderTraverse(node.rchild);
        }
    }

    public static void main(String[] args) {
        AVLTree2<Integer> avl = new AVLTree2<Integer>();
        avl.insert(new Integer(80));
        avl.insert(new Integer(60));
        avl.insert(new Integer(90));
        avl.insert(new Integer(85));
        avl.insert(new Integer(120));
        avl.insert(new Integer(100));
        System.out.println("\u524d\u5e8f\u904d\u5386AVL\uff1a");
        avl.preOrderTraverse(avl.getRoot());
    }
}

