/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.algorithm;

public class TrieTree {
    private int SIZE = 26;
    private TrieNode root = new TrieNode();

    TrieTree() {
    }

    public void insert(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        TrieNode node = this.root;
        char[] letters = str.toCharArray();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int pos = letters[i] - 97;
            if (node.son[pos] == null) {
                ((TrieNode)node).son[pos] = new TrieNode();
                node.son[pos].val = letters[i];
            } else {
                node.son[pos].num++;
            }
            node = node.son[pos];
        }
        node.isEnd = true;
        node.totalWord = str;
    }

    public int countPrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return -1;
        }
        TrieNode node = this.root;
        char[] letters = prefix.toCharArray();
        int len = prefix.length();
        for (int i = 0; i < len; ++i) {
            int pos = letters[i] - 97;
            if (node.son[pos] == null) {
                return 0;
            }
            node = node.son[pos];
        }
        return node.num;
    }

    public boolean has(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        TrieNode node = this.root;
        char[] letters = str.toCharArray();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int pos = letters[i] - 97;
            if (node.son[pos] == null) {
                return false;
            }
            node = node.son[pos];
        }
        return node.isEnd;
    }

    public void preTraverse(TrieNode node) {
        if (node != null) {
            if (node.totalWord != null) {
                System.out.print(node.totalWord + "-");
            }
            for (TrieNode child : node.son) {
                this.preTraverse(child);
            }
        }
    }

    public TrieNode getRoot() {
        return this.root;
    }

    public static void main(String[] args) {
        TrieTree tree = new TrieTree();
        String[] strs = new String[]{"banana", "band", "bee", "absolute", "acm"};
        String[] prefix = new String[]{"ba", "b", "band", "abc"};
        for (String str : strs) {
            tree.insert(str);
        }
        System.out.println(tree.has("abc"));
        tree.preTraverse(tree.getRoot());
        System.out.println();
        for (String pre : prefix) {
            int num = tree.countPrefix(pre);
            System.out.println(pre + " " + num);
        }
    }

    private class TrieNode {
        private int num = 1;
        private TrieNode[] son;
        private boolean isEnd;
        private char val;
        private String totalWord;

        TrieNode() {
            this.son = new TrieNode[TrieTree.this.SIZE];
            this.isEnd = false;
        }
    }
}

