/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.kafka.reader;

import com.bfd.dp.kfk.util.LoadConfig;
import com.fuwenchao.kafka.reader.ExampleUtils;
import com.fuwenchao.kafka.reader.WorkQueue;
import com.fuwenchao.utils.MyDateUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.message.Message;
import org.apache.log4j.Logger;

public class ConsumerExample {
    public static final Logger LOG = Logger.getLogger(ConsumerExample.class);

    private static ConsumerConfig createConsumerConfig() {
        Properties pro = LoadConfig.getInstance().getPro("../etc/config");
        Properties props = new Properties();
        props.put("zk.connect", pro.getProperty("dsp_kafkazk_address", "192.168.50.11:2191,192.168.50.12:2191,192.168.50.13:2191,192.168.50.14:2191,192.168.50.15:2191/kafka07dmp"));
        props.put("groupid", LoadConfig.getInstance().getPro("../etc/config").getProperty("DSP.topicreader.groupid", "DSPkafkacrawl"));
        props.put("zk.sessiontimeout.ms", "50000");
        props.put("zk.synctime.ms", "50000");
        props.put("autocommit.interval.ms", "50000");
        return new ConsumerConfig(props);
    }

    public static Map<String, Integer> getTopicMap() {
        String[] topicArray;
        String topics = "DS.CookieMapping.GDMP,DS.CookieMapping.GDMP2,DS.CookieMapping.GDMP3,DS.CookieMapping.GDMP4,DS.CookieMapping.GDMP5";
        HashMap<String, Integer> topicMap = new HashMap<String, Integer>();
        for (String str : topicArray = topics.split(",")) {
            topicMap.put(str, 2);
        }
        return topicMap;
    }

    public static void startReadThread() {
        Map<String, Integer> topicCountMap = ConsumerExample.getTopicMap();
        ConsumerConnector consumer = Consumer.createJavaConsumerConnector((ConsumerConfig)ConsumerExample.createConsumerConfig());
        Map consumerMap = consumer.createMessageStreams(topicCountMap);
        Iterator it = consumerMap.entrySet().iterator();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            final String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            for (final KafkaStream ks : value) {
                executor.execute(new Runnable(){

                    public String getThreadName() {
                        return Thread.currentThread().getName();
                    }

                    @Override
                    public void run() {
                        LOG.info((Object)("begin run method !thread name is " + Thread.currentThread().getName() + ".topic is " + key));
                        ConsumerIterator it = ks.iterator();
                        String temp = "";
                        long getMessageNums = 0L;
                        long todayGetMessageNum = 0L;
                        String dateStr = MyDateUtil.getStr(new Date(), "yyyy-MM-dd");
                        long beginTime = new Date().getTime();
                        while (it.hasNext()) {
                            try {
                                temp = ExampleUtils.getMessage((Message)it.next().message());
                                try {
                                    WorkQueue.messagequeue.put(temp);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                ++todayGetMessageNum;
                                if (!MyDateUtil.getStr(new Date(), "yyyy-MM-dd").equals(dateStr)) {
                                    todayGetMessageNum = 0L;
                                    dateStr = MyDateUtil.getStr(new Date(), "yyyy-MM-dd");
                                }
                                ++getMessageNums;
                                if (new Date().getTime() - beginTime <= 100000L) continue;
                                LOG.info((Object)(this.getThreadName() + ".topic is " + key + ".last 100 second get message nums is " + getMessageNums));
                                LOG.info((Object)(this.getThreadName() + ".today get message total is " + todayGetMessageNum));
                                getMessageNums = 0L;
                                beginTime = new Date().getTime();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }

    public static void main(String[] args) {
    }
}

