/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.kafka.writer;

import java.util.List;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.javaapi.producer.ProducerData;
import kafka.producer.ProducerConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class KfkProducer {
    private static final Log LOG = LogFactory.getLog(KfkProducer.class);
    private Producer<String, String> producter = null;
    private Properties props;
    private String name;

    public boolean send(String topic, String message) {
        if (StringUtils.isEmpty((String)topic) || StringUtils.isEmpty((String)message)) {
            LOG.warn((Object)"before send msg get topic or message -> null, projName=");
            return false;
        }
        ProducerData producerData = new ProducerData(topic, (Object)message);
        try {
            this.producter.send(producerData);
        }
        catch (Exception e) {
            LOG.warn((Object)(Thread.currentThread().getName() + ":topic is " + topic + ".message is " + message + ".send data exception, err="), (Throwable)e);
            this.close();
            ProducerConfig config = new ProducerConfig(this.props);
            this.producter = new Producer(config);
            return false;
        }
        return true;
    }

    public boolean send(String topic, List<String> messages) {
        if (messages == null || messages.size() == 0) {
            LOG.warn((Object)"before send msg get topic or message -> null, projName=");
            return false;
        }
        ProducerData producerData = new ProducerData(topic, messages);
        try {
            this.producter.send(producerData);
        }
        catch (Exception e) {
            LOG.warn((Object)(Thread.currentThread().getName() + ":topic is " + topic + ".message size is " + messages.size() + ".send data exception, err="), (Throwable)e);
            this.close();
            ProducerConfig config = new ProducerConfig(this.props);
            this.producter = new Producer(config);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.producter != null) {
            try {
                this.producter.close();
            }
            catch (Exception e) {
                LOG.warn((Object)"close producter exception, err=", (Throwable)e);
            }
            finally {
                this.producter = null;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"../etc/log4j.properties");
    }
}

