/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.templateParser;

import com.fuwenchao.templateParser.DomCFGElement;
import com.fuwenchao.templateParser.DomSearch;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class DomCFGField
implements DomCFGElement {
    private static final Log LOG = LogFactory.getLog(DomCFGField.class);
    private String name;
    private String[] path;
    private String extFilter;
    boolean isMulti;
    int multiLevel;
    boolean isUseIndex;
    private boolean isLink;
    private String linkType;
    private boolean needImg = false;
    private boolean isImg = false;
    private String attName;
    private boolean html = false;
    private String linkAtt;
    private boolean rmHead = false;
    private boolean rmTail = false;
    private String segflag = null;
    private boolean needSegm = false;

    public DomCFGField(Node node) {
        this.init(node);
    }

    public void init(Node node) {
        String hrefTempName;
        String isImg;
        String needImg;
        String sName = node.getNodeName();
        if (!"fld".equalsIgnoreCase(sName)) {
            return;
        }
        this.name = DomSearch.getNodeAttr(node, "name", "");
        String stmp = DomSearch.getNodeAttr(node, "multi", "");
        if (stmp.equalsIgnoreCase("true")) {
            this.isMulti = true;
            stmp = DomSearch.getNodeAttr(node, "multiLevel", "0");
            try {
                this.multiLevel = Integer.parseInt(stmp);
            }
            catch (NumberFormatException x) {
                this.multiLevel = -1;
            }
        } else {
            this.isMulti = false;
            this.multiLevel = -1;
        }
        this.extFilter = DomSearch.getNodeAttr(node, "ext", "");
        stmp = DomSearch.getNodeAttr(node, "path", "");
        if (stmp.length() > 0) {
            this.path = stmp.split("/");
        }
        if ("true".equalsIgnoreCase(needImg = DomSearch.getNodeAttr(node, "needImg", "")) || "contents".equalsIgnoreCase(this.name)) {
            this.needImg = true;
        }
        if ("true".equalsIgnoreCase(isImg = DomSearch.getNodeAttr(node, "isImg", "")) || "small_img".equalsIgnoreCase(this.name) || "large_img".equalsIgnoreCase(this.name) || "imgurl".equalsIgnoreCase(this.name) || "img".equalsIgnoreCase(this.name)) {
            this.isImg = true;
        }
        this.attName = DomSearch.getNodeAttr(node, "attname", "");
        String html = DomSearch.getNodeAttr(node, "html", "");
        if ("true".equalsIgnoreCase(html)) {
            this.html = true;
        }
        if ((hrefTempName = DomSearch.getNodeAttr(node, "link", "")).equalsIgnoreCase("true")) {
            this.isLink = true;
            this.linkAtt = DomSearch.getNodeAttr(node, "linkatt", "href");
            this.linkType = DomSearch.getNodeAttr(node, "linktype", null);
        } else {
            this.isLink = false;
        }
        this.segflag = DomSearch.getNodeAttr(node, "segflag", null);
        if (StringUtils.isNotEmpty((String)this.segflag)) {
            this.needSegm = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isMultiField() {
        return this.isMulti;
    }

    public boolean collectImg() {
        return this.needImg;
    }

    public boolean isImg() {
        return this.isImg;
    }

    public boolean isHtml() {
        return this.html;
    }

    public boolean useIndex() {
        return this.isUseIndex;
    }

    public int getMultiLevel() {
        return this.multiLevel;
    }

    public String[] getFieldPath() {
        return this.path;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getLinkAtt() {
        return this.linkAtt;
    }

    public String attName() {
        return this.attName;
    }

    public String getSegmflag() {
        return this.segflag;
    }

    public boolean needSegm() {
        return this.needSegm;
    }

    public String toString() {
        String res = "name=" + this.name;
        if (this.path == null) {
            res = res + ", No path";
        } else {
            for (int i = 0; i < this.path.length; ++i) {
                res = i > 0 ? res + "/" + this.path[i] : res + ", path=" + this.path[i];
            }
        }
        if (this.extFilter != null) {
            res = res + ",ext=" + this.extFilter;
        }
        res = res + ",isMulti=" + this.isMulti;
        res = res + ",isUseIndex=" + this.isUseIndex;
        res = res + ",multiLevel=" + this.multiLevel;
        res = res + ",isLink=" + this.isLink;
        res = res + ",linkTpye=" + this.linkType;
        return res;
    }
}

