/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.templateParser;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fuwenchao.templateParser.DomCFGTree;
import com.fuwenchao.templateParser.DomParser;
import com.fuwenchao.templateParser.DomTemplate;
import com.fuwenchao.templateParser.Template;
import com.fuwenchao.templateParser.TwoTuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class DomConfig {
    private static final Log log = LogFactory.getLog(DomConfig.class);
    private static final String CONFIG_NAME = "dom_config";
    private static volatile DomConfig instance;
    private Map<String, DomTemplate> siteTmpls = new ConcurrentHashMap<String, DomTemplate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomConfig getInstance() {
        if (instance != null) return instance;
        Class<DomConfig> clazz = DomConfig.class;
        synchronized (DomConfig.class) {
            if (instance != null) return instance;
            instance = new DomConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected DomConfig() {
    }

    public boolean hasTemplate(String sitename) {
        return this.siteTmpls.containsKey(sitename);
    }

    public synchronized DomTemplate readBuziConfig(List<Template> list) {
        if (list != null && list.size() > 0) {
            ArrayList<TwoTuple<Node, Object>> listChilds = new ArrayList<TwoTuple<Node, Object>>();
            String XMLhead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            for (Template template : list) {
                if (StringUtils.isEmpty((String)template.getTmpl())) {
                    log.warn((Object)("error template, tmpl is empty, tmpl id=" + template.getId()));
                    continue;
                }
                StringBuilder sbBuilder = new StringBuilder();
                sbBuilder.append(XMLhead);
                sbBuilder.append(template.getTmpl());
                DocumentFragment doc = DomParser.parse2Xml(sbBuilder.toString(), "utf8");
                listChilds.add(new TwoTuple<Node, Template>(doc.getFirstChild(), template));
            }
            return new DomTemplate(list.get(0), listChilds);
        }
        return null;
    }

    public DomCFGTree readBuziConfig(Template template) {
        String XMLhead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        StringBuilder sbBuilder = new StringBuilder();
        String tmpl = template.getTmpl();
        sbBuilder.append(XMLhead);
        sbBuilder.append(tmpl);
        DocumentFragment doc = DomParser.parse2Xml(sbBuilder.toString(), "utf8");
        return new DomCFGTree(doc.getFirstChild(), template);
    }

    public synchronized DomTemplate readBuziConfig2(List<Template> list) {
        if (list != null && list.size() > 0) {
            ArrayList<TwoTuple<Node, Object>> listChilds = new ArrayList<TwoTuple<Node, Object>>();
            String XMLhead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            for (Template template : list) {
                StringBuilder sbBuilder = new StringBuilder();
                String tmpl = template.getTmpl();
                sbBuilder.append(XMLhead);
                sbBuilder.append(tmpl);
                DocumentFragment doc = DomParser.parse2Xml(sbBuilder.toString(), "utf8");
                listChilds.add(new TwoTuple<Node, Template>(doc.getFirstChild(), template));
            }
            return new DomTemplate(list.get(0), listChilds);
        }
        return null;
    }

    public static void main(String[] args) {
        String xml = "<tmpl path='div@@searchwrap w980@4'><fld name='category' path='div@@searchCrumb@2' multi='' ext=''/><block path='div@@itemSearchResult @*/ul@@@0/li@@producteg@*' name='items'><fld name='imgurl' path='a@@@0/img@@@0' multi='' ext=''/><fld name='itemlink' path='a@@title@1' multi='' ext='' link='true' linkType='item'/><fld name='price' path='p@@price@0/strong@@@0' multi='' ext=''/><block path='div@@test@*' name='tests'><fld name='test' path='p@@@0' multi='' ext=''></block></block></tmpl>";
        Template t2 = new Template();
        t2.setActive(0);
        t2.setAlias("");
        t2.setCid("Cyouhao");
        t2.setDns("youhao.com");
        t2.setNodeName("Cyouhao");
        t2.setNum(3);
        t2.setOutput("category,items");
        t2.setRequired("items");
        t2.setTmpl(xml);
        t2.setType("list");
        ArrayList<Template> list = new ArrayList<Template>();
        list.add(t2);
        DomTemplate template = new DomConfig().readBuziConfig2(list);
        if (log.isDebugEnabled()) {
            log.debug((Object)("=========" + template.getTemplates().get(0).getTreePath()));
        }
    }

    public static List<Template> parseAllTemplates2(String templates) {
        ArrayList<Template> list = new ArrayList<Template>();
        ObjectMapper om = new ObjectMapper();
        try {
            Map readValue = (Map)om.readValue(templates, Map.class);
            for (Object o : (List)readValue.get("all")) {
                Map template = (Map)o;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public DomTemplate getByHostname(String hostname) {
        String[] hostSegs = hostname.split("\\.");
        if (log.isDebugEnabled()) {
            log.debug((Object)("hostname=" + hostname + ", length=" + hostSegs.length));
        }
        String dns = hostSegs[hostSegs.length - 1];
        for (int i = hostSegs.length - 2; i >= 0; --i) {
            dns = hostSegs[i] + "." + dns;
            DomTemplate template = this.get(dns);
            if (template == null) continue;
            return template;
        }
        return null;
    }

    public DomTemplate getByBizid(String bid) {
        return this.get(bid);
    }

    public DomTemplate get(String bid) {
        if (this.siteTmpls.containsKey(bid)) {
            return this.siteTmpls.get(bid);
        }
        return null;
    }

    public void getWithRequest(String bid, String type) {
    }

    public List<DomCFGTree> get(String bid, String type) {
        DomTemplate domTemplate = this.get(bid);
        ArrayList<DomCFGTree> templates = new ArrayList<DomCFGTree>();
        if (domTemplate != null) {
            templates = domTemplate.getTemplates();
            for (DomCFGTree tree : templates) {
                if (!tree.getType().equals(type)) continue;
                templates.add(tree);
            }
        }
        return templates;
    }
}

