/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.templateParser;

import com.fuwenchao.templateParser.DomCFGTree;
import com.fuwenchao.templateParser.DomConfig;
import com.fuwenchao.templateParser.DomSearch;
import com.fuwenchao.templateParser.Template;
import com.fuwenchao.templateParser.TwoTuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class DomTemplate {
    private static final Log LOG = LogFactory.getLog(DomTemplate.class);
    String name;
    String[] required;
    String[] alias;
    String bid;
    String dns;
    String urlfilter;
    Map<String, Boolean> output;
    ArrayList<DomCFGTree> tmpl;

    public DomTemplate(Template template) {
        this.output = new HashMap<String, Boolean>();
        String stmp = template.getRequired();
        if (stmp.length() > 0) {
            this.required = stmp.split(",");
        }
        if ((stmp = template.getOutput()).length() > 0) {
            String[] ss = stmp.split(",");
            for (int i = 0; i < ss.length; ++i) {
                this.output.put(ss[i], true);
            }
        }
        if (StringUtils.isNotEmpty((String)(stmp = template.getDns())) && stmp.length() > 0) {
            this.dns = stmp;
        }
        if (StringUtils.isNotEmpty((String)(stmp = template.getCid())) && stmp.length() > 0) {
            this.bid = stmp;
        }
        if (StringUtils.isNotEmpty((String)(stmp = template.getAlias())) && stmp.length() > 0) {
            this.alias = stmp.split(",");
        }
        this.tmpl = new ArrayList();
        DomCFGTree domConfigTree = DomConfig.getInstance().readBuziConfig(template);
        this.tmpl.add(domConfigTree);
    }

    public String getTemplateName() {
        return this.name;
    }

    public String toString() {
        int i;
        String res = "name=" + this.name + ", dns=" + this.dns;
        if (this.bid != null) {
            res = res + ",bid=" + this.bid;
        }
        if (this.urlfilter != null) {
            res = res + ",urlfilter=" + this.urlfilter;
        }
        if (this.required != null) {
            res = res + ", required:";
            for (i = 0; i < this.required.length; ++i) {
                res = res + " " + this.required[i];
            }
        }
        if (this.alias != null) {
            res = res + ", Alias:";
            for (i = 0; i < this.alias.length; ++i) {
                res = res + " " + this.alias[i];
            }
        }
        res = res + ", output fields:";
        if (this.output != null && this.output.size() > 0) {
            Object[] objs = this.output.keySet().toArray();
            for (int i2 = 0; i2 < objs.length; ++i2) {
                res = res + " " + (String)objs[i2];
            }
        } else {
            res = res + "not output";
        }
        if (this.urlfilter != null) {
            res = res + ",urlfilter=" + this.urlfilter;
        }
        for (int i3 = 0; i3 < this.tmpl.size(); ++i3) {
            res = res + ", template-" + i3 + " is: " + this.tmpl;
        }
        return res;
    }

    public DomTemplate(Node node) {
        this.name = node.getNodeName();
        this.output = new HashMap<String, Boolean>();
        this.tmpl = new ArrayList();
        String stmp = DomSearch.getNodeAttr(node, "required", "");
        if (stmp.length() > 0) {
            this.required = stmp.split(",");
        }
        if ((stmp = DomSearch.getNodeAttr(node, "output", "")).length() > 0) {
            String[] ss = stmp.split(",");
            for (int i = 0; i < ss.length; ++i) {
                this.output.put(ss[i], true);
            }
        }
        if ((stmp = DomSearch.getNodeAttr(node, "dns", "")).length() > 0) {
            this.dns = stmp;
        }
        if ((stmp = DomSearch.getNodeAttr(node, "bid", "")).length() > 0) {
            this.bid = stmp;
        }
        if ((stmp = DomSearch.getNodeAttr(node, "urlfilter", "")).length() > 0) {
            this.urlfilter = stmp;
        }
        if ((stmp = DomSearch.getNodeAttr(node, "alias", "")).length() > 0) {
            this.alias = stmp.split(",");
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!"tmpl".equalsIgnoreCase(child.getNodeName())) continue;
            this.tmpl.add(new DomCFGTree(child));
        }
        LOG.trace((Object)("load template for " + this.name + " is OK, dns=" + this.dns + ",urlfilter+" + this.urlfilter + ", alias=" + stmp));
    }

    public DomTemplate(Template template, List<TwoTuple<Node, Object>> listChilds) {
        this.name = template.getNodeName();
        this.tmpl = new ArrayList();
        this.output = new HashMap<String, Boolean>();
        String stmp = template.getRequired();
        if (stmp.length() > 0) {
            this.required = stmp.split(",");
        }
        if ((stmp = template.getOutput()).length() > 0) {
            String[] ss = stmp.split(",");
            for (int i = 0; i < ss.length; ++i) {
                this.output.put(ss[i], true);
            }
        }
        if (StringUtils.isNotEmpty((String)(stmp = template.getDns())) && stmp.length() > 0) {
            this.dns = stmp;
        }
        if (StringUtils.isNotEmpty((String)(stmp = template.getCid())) && stmp.length() > 0) {
            this.bid = stmp;
        }
        if (StringUtils.isNotEmpty((String)(stmp = template.getAlias())) && stmp.length() > 0) {
            this.alias = stmp.split(",");
        }
        for (TwoTuple<Node, Object> twoTuple : listChilds) {
            Template newTemplate = (Template)twoTuple.second;
            Node child = (Node)twoTuple.first;
            if (!"tmpl".equalsIgnoreCase(child.getNodeName())) continue;
            this.tmpl.add(new DomCFGTree(child, newTemplate));
        }
        LOG.trace((Object)("load template for " + this.name + " is OK, dns=" + this.dns + ", alias=" + stmp));
    }

    public int getTemplateCount() {
        return this.tmpl.size();
    }

    public DomCFGTree getTemplate(int index) {
        if (index >= 0 && index < this.tmpl.size()) {
            return this.tmpl.get(index);
        }
        return null;
    }

    public String getURLRule() {
        return this.urlfilter;
    }

    public String getBuziID() {
        return this.bid;
    }

    public String getDNS() {
        return this.dns;
    }

    public String[] getRequiredField() {
        return this.required;
    }

    public Map<String, Boolean> getOutputField() {
        return this.output;
    }

    public String[] getAlias() {
        return this.alias;
    }

    public ArrayList<DomCFGTree> getTemplates() {
        return this.tmpl;
    }
}

