/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.thread;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public final class ContextSwitchTest {
    static final int RUNS = 3;
    static final int ITERATES = 1000000;
    static AtomicReference turn = new AtomicReference();

    static void test() throws Exception {
        WorkerThread a = new WorkerThread();
        WorkerThread b = new WorkerThread();
        a.other = b;
        b.other = a;
        turn.set(a);
        long startTime = System.nanoTime();
        a.start();
        b.start();
        a.join();
        b.join();
        long endTime = System.nanoTime();
        int parkNum = a.nparks + b.nparks;
        System.out.println("Average time: " + (endTime - startTime) / (long)parkNum + "ns");
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 3; ++i) {
            ContextSwitchTest.test();
        }
    }

    static final class WorkerThread
    extends Thread {
        volatile Thread other;
        volatile int nparks;

        WorkerThread() {
        }

        @Override
        public void run() {
            AtomicReference t2 = turn;
            Thread other = this.other;
            if (turn == null || other == null) {
                throw new NullPointerException();
            }
            int p = 0;
            for (int i = 0; i < 1000000; ++i) {
                while (!t2.compareAndSet(other, this)) {
                    LockSupport.park();
                    ++p;
                }
                LockSupport.unpark(other);
            }
            LockSupport.unpark(other);
            this.nparks = p;
            System.out.println("parks: " + p);
        }
    }
}

