/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.tmptask.huafen.parser;

import com.bfd.crawler.download.httclient43.crawler.httpclient.Crawl4HttpClient;
import com.fuwenchao.tmptask.Constants;
import com.fuwenchao.tmptask.Iparser;
import com.fuwenchao.tmptask.Task;
import com.fuwenchao.tmptask.Utils;
import com.fuwenchao.tmptask.WorkQueue;
import com.fuwenchao.tmptask.huafen.jdbc.Dboption;
import com.fuwenchao.utils.TextUtil;
import com.fuwenchao.utils.httpclient.MyCrawler;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XPatherException;

public class HuaFenItemParser
implements Iparser {
    private static Logger log = Logger.getLogger(HuaFenItemParser.class);
    public static Pattern pSubjectId = Pattern.compile("thread-(\\d+?)-");
    public static Pattern pTitle = Pattern.compile("<span\\s+?id=\"thread_subject\">([\\s\\S]*?)</span>");
    public static Dboption dbOption = new Dboption();
    public static Pattern pTime = Pattern.compile("(\\d+?)\\s*?(\u5929|\u5c0f\u65f6|\u5206\u949f|\u79d2)\u524d");

    @Override
    public Map<String, Object> parseHtml(String html, Task task) {
        String subjectId = "";
        try {
            subjectId = TextUtil.getRegexGroup(pSubjectId, task.getUrl(), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("error url : " + task.getUrl()));
        }
        try {
            HtmlCleaner cleaner = new HtmlCleaner();
            TagNode root = cleaner.clean(html);
            Object[] objs = root.evaluateXPath("//table[@class='plhin']");
            for (int i = 0; i < objs.length; ++i) {
                TagNode node = (TagNode)objs[i];
                if (task.getUrl().indexOf("-1-") > 0 && i == 0) {
                    this.getSubject(html, node, task.getUrl(), subjectId, root);
                    continue;
                }
                this.getReply(html, node, task.getUrl(), subjectId);
            }
            this.getReplyPage(html, task.getUrl(), root);
        }
        catch (XPatherException e1) {
            e1.printStackTrace();
            log.error((Object)("error url : " + task.getUrl()));
        }
        return null;
    }

    private void getReply(String html, TagNode replyNode, String url, String subjectId) {
        try {
            Object[] objs = replyNode.evaluateXPath(".//div[@class='authi']");
            if (objs == null || objs.length == 0) {
                log.info((Object)(Utils.getCurrentThreadName() + " url:" + url + ". is has not author!"));
                return;
            }
            TagNode authorNode = (TagNode)objs[0];
            Object[] authorObj = authorNode.evaluateXPath(".//a[@class='xi2 z']");
            TagNode a = (TagNode)authorObj[0];
            String authorId = a.getText().toString().trim();
            String userurl = "http://www.huafans.cn/" + a.getAttributeByName("href");
            authorId = authorId.replaceAll("'", "\\'");
            String userId = Utils.getIntFromString(userurl);
            String online = this.getOnlineTime(userId);
            if (online.trim().length() == 0) {
                online = "0";
            }
            Task task = new Task();
            task.getAttr().put(Constants.online, online);
            task.setType(Constants.TASK_TYPE_USERINFO);
            task.setUrl(userurl);
            WorkQueue.putTask(task);
        }
        catch (XPatherException e) {
            e.printStackTrace();
            log.error((Object)(Utils.getCurrentThreadName() + " error url is " + url));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)(Utils.getCurrentThreadName() + " error url is " + url));
        }
    }

    private String getOnlineTime(String authorId) {
        String online = "0";
        try {
            authorId = authorId.replace(" ", "+");
            String url = "http://www.huafans.cn/space-uid-" + authorId + ".html?ajaxmenu=1&inajax=1";
            String html = Crawl4HttpClient.getHtmlByDefaultHeader((String)url);
            Pattern p = Pattern.compile("\u5728\u7ebf\u65f6\u95f4: (\\d+) \u5c0f\u65f6");
            Matcher m = p.matcher(html);
            online = "";
            if (m.find()) {
                online = m.group(1);
            }
            if (online.trim().length() == 0) {
                log.info((Object)(Utils.getCurrentThreadName() + " online length is 0.url:" + url));
            }
        }
        catch (Exception e) {
            online = "0";
            e.printStackTrace();
        }
        return online.trim();
    }

    private void getSubject(String html, TagNode subjectNode, String url, String subjectId, TagNode root) {
        try {
            Object[] objs = subjectNode.evaluateXPath(".//div[@class='authi']");
            if (objs == null || objs.length == 0) {
                log.info((Object)(Utils.getCurrentThreadName() + " url:" + url + ". is has not author!"));
                return;
            }
            TagNode authorNode = (TagNode)objs[0];
            Object[] authorObj = authorNode.evaluateXPath(".//a");
            TagNode a = (TagNode)authorObj[1];
            String authorId = a.getText().toString().trim();
            String userurl = "http://www.huafans.cn/" + a.getAttributeByName("href");
            String online = this.getOnlineTime(authorId = authorId.replaceAll("'", "\\'"));
            if (online.trim().length() == 0) {
                online = "0";
            }
            Task task = new Task();
            task.getAttr().put("online", online);
            task.setType(Constants.TASK_TYPE_USERINFO);
            task.setUrl(userurl);
            WorkQueue.putTask(task);
        }
        catch (XPatherException e) {
            e.printStackTrace();
            log.error((Object)(Utils.getCurrentThreadName() + " error url :" + url));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)(Utils.getCurrentThreadName() + " error url :" + url));
        }
    }

    private void getReplyPage(String html, String url, TagNode root) {
        try {
            Object[] objs = root.evaluateXPath("//div[@class='pg']");
            if (objs == null || objs.length == 0) {
                log.info((Object)(Utils.getCurrentThreadName() + " url:" + url + ".no page!"));
                return;
            }
            Object[] hrefs = ((TagNode)objs[0]).evaluateXPath(".//a");
            for (int i = 0; i < hrefs.length; ++i) {
                String tempUrl = ((TagNode)hrefs[i]).getAttributeByName("href");
                Task task = new Task();
                if (tempUrl.indexOf("http://www.huafans.cn/") >= 0) {
                    task.setUrl(tempUrl);
                } else {
                    task.setUrl("http://www.huafans.cn/" + tempUrl);
                }
                task.setType(Constants.TASK_TYPE_ITEM);
                WorkQueue.putTask(task);
            }
            log.info((Object)(Utils.getCurrentThreadName() + " url:" + url + ".get reply page size is " + hrefs.length));
        }
        catch (XPatherException e1) {
            e1.printStackTrace();
            log.error((Object)(Utils.getCurrentThreadName() + " the error url is " + url));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)(Utils.getCurrentThreadName() + " error url is " + url));
        }
    }

    public static void main(String[] args) {
        String replyUrl;
        String url = replyUrl = "http://cn.club.vmall.com/forum-492-1.html";
        String html = new MyCrawler().get(url)[1];
        html = html.replaceAll("&quot;", "\"");
        System.out.println(html);
        System.out.println(new HuaFenItemParser().getOnlineTime("7848598"));
    }

    public static void main3(String[] args) {
        String str = "\u53d1\u8868\u4e8e 13\u79d2\u524d";
    }
}

