/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class DataUtil {
    private static final Log LOG = LogFactory.getLog(DataUtil.class);
    private static final byte[] _hexChars = "0123456789abcdef".getBytes();

    public static String calcMD5(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return DataUtil.toHexString(md.digest(data.getBytes()));
        }
        catch (Exception x) {
            LOG.warn((Object)("calc MD5 error, msg:" + x.getMessage()));
            return "";
        }
    }

    public static String toHexString(byte[] b) {
        StringBuffer s = new StringBuffer(2 * b.length);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            s.append((char)_hexChars[v >> 4]);
            s.append((char)_hexChars[v & 0xF]);
        }
        return s.toString();
    }

    public static String zipAndEncode(String data, String charset) throws Exception {
        return DataUtil.encodeBase64(DataUtil.zipData(data.getBytes(charset)));
    }

    public static byte[] unzipAndDecode(String data) throws Exception {
        return DataUtil.unzipData(DataUtil.decodeBase64(data));
    }

    public static byte[] decodeBase64(String data) throws IOException {
        BASE64Decoder decoder = new BASE64Decoder();
        return decoder.decodeBuffer(data);
    }

    public static String encodeBase64(byte[] data) throws IOException {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public static byte[] unzipData(byte[] data) throws Exception {
        Inflater _infl = new Inflater();
        _infl.setInput(data);
        int storelen = 0;
        int ileft = 0;
        byte[] buf = new byte[data.length << 3];
        byte[] tmpbuf = null;
        storelen += _infl.inflate(buf);
        ileft = _infl.getRemaining();
        if (ileft > 0) {
            tmpbuf = new byte[data.length << 1];
        }
        while (ileft > 0) {
            int isize = _infl.inflate(tmpbuf);
            ileft = _infl.getRemaining();
            byte[] dstbuf = new byte[storelen + isize];
            System.arraycopy(buf, 0, dstbuf, 0, buf.length);
            System.arraycopy(tmpbuf, 0, dstbuf, buf.length, isize);
            buf = dstbuf;
            storelen += isize;
        }
        _infl.end();
        if (storelen == buf.length) {
            return buf;
        }
        byte[] btret = new byte[storelen];
        System.arraycopy(buf, 0, btret, 0, storelen);
        return btret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zipData(byte[] data) throws Exception {
        byte[] output = new byte[]{};
        Deflater compresser = new Deflater(1);
        compresser.reset();
        compresser.setInput(data);
        compresser.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        try {
            byte[] buf = new byte[1024];
            while (!compresser.finished()) {
                int i = compresser.deflate(buf);
                bos.write(buf, 0, i);
            }
            output = bos.toByteArray();
        }
        catch (Exception e) {
            output = data;
            e.printStackTrace();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        compresser.end();
        return output;
    }

    public static String decode(String data) {
        byte[] bt = data.getBytes();
        byte[] btres = new byte[bt.length];
        int i = 0;
        int j = 0;
        i = 0;
        j = 0;
        while (j < bt.length) {
            if ((bt[j] & 0xFC) == 192) {
                btres[i] = (byte)((bt[j] & 3) << 6 | bt[j + 1] & 0x3F);
                j += 2;
            } else {
                btres[i] = bt[j++];
            }
            ++i;
        }
        try {
            return new String(btres, 0, i, "utf8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.info((Object)("decode data exception, data: " + data + "\n error msg:" + e.getMessage()));
            return data;
        }
    }

    public static byte[] trimBadChar(byte[] data) {
        int j = 0;
        boolean ff = false;
        int spc = 0;
        int cspc = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] >= 0 && data[i] <= 32) {
                ++spc;
                if (j < 1) continue;
                if (ff) {
                    if (data[i] != 9 || data[j - 1] == 9) continue;
                    data[j - 1] = 9;
                    continue;
                }
                data[j++] = data[i] == 9 ? 9 : 32;
                ff = true;
                continue;
            }
            if ((data[i] & 0xFF) == 194 && i < data.length - 1 && ((data[i + 1] & 0xFF) == 160 || (data[i + 1] & 0xFF) == 161)) {
                if (!ff) {
                    data[j++] = 32;
                    ff = true;
                }
                ++i;
                ++cspc;
                continue;
            }
            if ((data[i] & 0xFF) == 227 && i < data.length - 2 && (data[i + 1] & 0xFF) == 128 && (data[i + 2] & 0xFF) == 128) {
                if (!ff) {
                    data[j++] = 32;
                    ff = true;
                }
                i += 2;
                ++cspc;
                continue;
            }
            data[j++] = data[i];
            ff = false;
        }
        if (j > 0 && (data[j - 1] == 32 || data[j - 1] == 9)) {
            --j;
        }
        return Arrays.copyOfRange(data, 0, j);
    }

    public static String strTrimBadChar(String txt) {
        return new String(DataUtil.trimBadChar(txt.getBytes()));
    }

    public static Date getRelativeDate(Date date, int field, int amount) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(field, amount);
        return gc.getTime();
    }

    public static Date getDate(String strDate, String format) {
        Date date = null;
        try {
            if (strDate != null && strDate.trim().length() != 0) {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                date = sdf.parse(strDate);
            }
        }
        catch (Exception ex) {
            date = new Date();
        }
        return date;
    }

    public static void main(String[] args) {
        String str = "test is ok";
        String encode = "gbk";
        try {
            String temp = DataUtil.zipAndEncode(str, "utf-8");
            System.out.println("zipStr:" + temp);
            String unzipStr = new String(DataUtil.unzipAndDecode(temp), encode);
            System.out.println("unzipStr:" + unzipStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

