/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.utils;

import com.fuwenchao.utils.MyStringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;

public class MyDateUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_SHORT_TIME_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String DEFAULT_DATE = "1970-1-1";

    public static Date getDate(String strDate) {
        return MyDateUtil.getDate(strDate, DATE_FORMAT);
    }

    public static Date getDate(String strDate, String format) {
        Date date = null;
        try {
            if (MyStringUtil.hasValue(strDate)) {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                date = sdf.parse(strDate);
            }
        }
        catch (Exception ex) {
            date = new Date();
        }
        return date;
    }

    public static Date getDateDefaultNull(String strDate, String format) {
        Date date = null;
        try {
            if (MyStringUtil.hasValue(strDate)) {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                date = sdf.parse(strDate);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return date;
    }

    public static String getStr(Date date, String format) {
        if (date != null) {
            SimpleDateFormat dFormat = new SimpleDateFormat(format);
            return dFormat.format(date);
        }
        return "";
    }

    public static String getStr(Date date) {
        return MyDateUtil.getStr(date, DATE_FORMAT);
    }

    public static Date getRelativeDate(Date date, int field, int amount) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(field, amount);
        return gc.getTime();
    }

    public static int[] getYearMonthDay(String yyyyMMdd) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        if (yyyyMMdd == null || !yyyyMMdd.matches("(19|20)\\d\\d(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])")) {
            yyyyMMdd = sf.format(new Date());
        }
        int[] values = new int[]{Integer.parseInt(yyyyMMdd.substring(0, 4)), Integer.parseInt(yyyyMMdd.substring(4, 6)), Integer.parseInt(yyyyMMdd.substring(6, 8))};
        return values;
    }

    public static int[] getYearMonthDay() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        String yyyyMMdd = sf.format(new Date());
        int[] values = new int[]{Integer.parseInt(yyyyMMdd.substring(0, 4)), Integer.parseInt(yyyyMMdd.substring(4, 6)), Integer.parseInt(yyyyMMdd.substring(6, 8))};
        return values;
    }

    public static int[] getYearMonthDay(Date date) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        String yyyyMMdd = sf.format(date);
        int[] values = new int[]{Integer.parseInt(yyyyMMdd.substring(0, 4)), Integer.parseInt(yyyyMMdd.substring(4, 6)), Integer.parseInt(yyyyMMdd.substring(6, 8))};
        return values;
    }

    public static int getDayInThisWeek(Date date) {
        String[] days = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        SimpleDateFormat f = new SimpleDateFormat("EEE", Locale.US);
        String weekday = f.format(date);
        for (int i = 0; i < days.length; ++i) {
            if (!days[i].equals(weekday)) continue;
            return i;
        }
        return 3;
    }

    public static String[] getMondaySunday(String yyyyMMdd) {
        Date today;
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        try {
            today = sf.parse(yyyyMMdd);
        }
        catch (Exception e) {
            today = new Date();
        }
        int week_day = MyDateUtil.getDayInThisWeek(today);
        Date monday = new Date(today.getTime() - (long)(week_day * 3600 * 1000 * 24));
        Date sunday = new Date(today.getTime() + (long)((7 - week_day) * 3600 * 1000 * 24));
        String[] mon_sun = new String[]{sf.format(monday), sf.format(sunday)};
        return mon_sun;
    }

    public static String[] getRelativeDatesInRange(Date date, int amount, String format) {
        int positive = 1;
        if (amount < 0) {
            positive = -1;
            amount = 0 - amount;
        }
        String[] dates = new String[amount];
        SimpleDateFormat sf = new SimpleDateFormat(format);
        long base_timestamp = date.getTime();
        for (int i = 0; i < amount; ++i) {
            Date current_date = new Date(base_timestamp - 86400000L * (long)i);
            String date_str = sf.format(current_date);
            int index = i;
            if (positive == -1) {
                index = amount - 1 - index;
            }
            dates[index] = date_str;
        }
        return dates;
    }

    public static String[] getRelativeDatesInRange(String base_date, int amount, String format) {
        Date date;
        int positive = 1;
        if (amount < 0) {
            positive = -1;
            amount = 0 - amount;
        }
        String[] dates = new String[amount];
        SimpleDateFormat sf = new SimpleDateFormat(format);
        try {
            date = sf.parse(base_date);
        }
        catch (Exception e) {
            date = new Date();
        }
        long base_timestamp = date.getTime();
        for (int i = 0; i < amount; ++i) {
            Date current_date = new Date(base_timestamp + 86400000L * (long)i * (long)positive);
            String date_str = sf.format(current_date);
            int index = i;
            if (positive == -1) {
                index = amount - 1 - index;
            }
            dates[index] = date_str;
        }
        return dates;
    }

    public static int[] getTodayByMonth(int[] yyyyMMdd, int months) {
        int[] newdate = new int[3];
        int ori_year = yyyyMMdd[0];
        int ori_month = yyyyMMdd[1];
        int ori_day = yyyyMMdd[2];
        int years = months / 12;
        int related_months = months % 12;
        ori_year += years;
        if (ori_month + related_months < 1) {
            newdate[0] = ori_year - 1;
            newdate[1] = ori_month + 12 + related_months;
        } else if (ori_month + related_months > 12) {
            newdate[0] = ori_year + 1;
            newdate[1] = ori_month - 12 + related_months;
        } else {
            newdate[0] = ori_year;
            newdate[1] = ori_month + related_months;
        }
        int day = MyDateUtil.getMaxDaysOfaMonth(newdate[0], newdate[1]);
        newdate[2] = ori_day > day ? day : ori_day;
        return newdate;
    }

    public static String[] getTodayNextDay(String yyyyMMdd) {
        Date today;
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        try {
            today = sf.parse(yyyyMMdd);
        }
        catch (Exception e) {
            today = new Date();
        }
        Date morrow = new Date(today.getTime() + 86400000L);
        String[] today_nextday = new String[]{sf.format(today), sf.format(morrow)};
        return today_nextday;
    }

    public static int getMaxDaysOfaMonth(int year, int month) {
        int days = 0;
        if (month != 2) {
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    days = 31;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    days = 30;
                }
            }
        } else {
            days = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
        }
        return days;
    }

    public static String getCurrentYear() {
        Date date = new Date();
        String currentyear = MyDateUtil.getStr(date, "yyyyMMdd").substring(0, 4);
        return currentyear;
    }

    public static String getCurrentYear(Date date) {
        String currentyear = MyDateUtil.getStr(date, "yyyyMMdd").substring(0, 4);
        return currentyear;
    }

    public static String getCurrentMonth(Date date) {
        String currentmonth = MyDateUtil.getStr(date, "yyyyMMdd").substring(4, 6);
        return currentmonth;
    }

    public static String getCurrentYear(String date) {
        String currentyear = date.substring(0, 4);
        return currentyear;
    }

    public static String getCurrentMonth() {
        Date date = new Date();
        String currentmonth = MyDateUtil.getStr(date, "yyyyMMdd").substring(4, 6);
        return currentmonth;
    }

    public static String getCurrentMonth(String date) {
        String currentmonth = date.substring(4, 6);
        return currentmonth;
    }

    public static String getCurrentDay() {
        Date date = new Date();
        String currentDay = MyDateUtil.getStr(date, "yyyyMMdd").substring(6, 8);
        return currentDay;
    }

    public static String getCurrentDay(String date) {
        String currentDay = date.substring(6, 8);
        return currentDay;
    }

    public static String getQday(String day, int i) {
        if (1 == (day = String.valueOf(Integer.parseInt(day) + i)).length()) {
            day = "0" + day;
        }
        return day;
    }

    public static String getQdate(String date) {
        String[] str = date.split(":");
        String year = str[0];
        String month = str[1];
        String day = str[2];
        if (1 == month.length()) {
            month = "0" + month;
        }
        if (1 == day.length()) {
            day = "0" + day;
        }
        return year + month + day;
    }

    public static String getDeQdate(String date) {
        String[] str = date.split(" ")[0].split("-");
        String year = str[0];
        String month = str[1];
        String day = str[2];
        if (1 == month.length()) {
            month = "0" + month;
        }
        if (1 == day.length()) {
            day = "0" + day;
        }
        return year + "-" + month + "-" + day;
    }

    public static String getFormateSomeDate(String format, Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        date = cal.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static int getIntervalDays(String begin, String end, String format) {
        SimpleDateFormat sf = new SimpleDateFormat(format);
        long days = 0L;
        try {
            Date dateBegin = sf.parse(begin);
            Date dateEnd = sf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(dateBegin);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dateEnd);
            long seconds = calEnd.getTimeInMillis() - calBegin.getTimeInMillis();
            days = seconds / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return Integer.parseInt(String.valueOf(days));
    }

    public static String changeFormat(String dateString, String oldFormat, String newFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(oldFormat);
        try {
            Date date = sdf.parse(dateString);
            sdf.applyPattern(newFormat);
            return sdf.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return dateString;
        }
    }

    public static int getDayOfMonth(String dateString, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Date date = dateFormat.parse(dateString);
            GregorianCalendar now = new GregorianCalendar();
            now.setTime(date);
            int dayOfMonth = now.get(5);
            return dayOfMonth;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static Date getDateFromString(String dateString, String format) {
        if (format == null || format.trim().equals("")) {
            format = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date date = new Date();
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getStringFromDate(Date date, String format) {
        if (format == null || format.trim().equals("")) {
            format = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String datestring = "";
        datestring = dateFormat.format(date);
        return datestring;
    }

    public static String getSameDayOfPastedMonth(String dateString, String dateformat, int amount) {
        if (dateformat == null) {
            dateformat = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
        try {
            Date date = dateFormat.parse(dateString);
            if (dateformat == null || dateformat.trim().equals("")) {
                dateformat = DATE_FORMAT;
            }
            GregorianCalendar now = new GregorianCalendar();
            now.setTime(date);
            int thisDay = now.get(5);
            now.add(2, -amount);
            if (now.getMaximum(5) < thisDay) {
                thisDay = now.getMaximum(5);
                now.set(5, thisDay);
            }
            String lastMonthday = dateFormat.format(now.getTime());
            return lastMonthday;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return dateString;
        }
    }

    public static String getWeek(String dateformat) {
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(new Date());
        now.add(6, -7);
        if (dateformat == null || dateformat.trim().equals("")) {
            dateformat = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
        return dateFormat.format(now.getTime());
    }

    public static String getWeek(String currentDate, String dateformat) {
        if (dateformat == null || dateformat.trim().equals("")) {
            dateformat = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
        GregorianCalendar now = new GregorianCalendar();
        try {
            now.setTime(dateFormat.parse(currentDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        now.add(6, -7);
        return dateFormat.format(now.getTime());
    }

    public static String getToday(String dateformat) {
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(new Date());
        if (dateformat == null || dateformat.trim().equals("")) {
            dateformat = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
        return dateFormat.format(now.getTime());
    }

    public static String getSeason(String dateformat) {
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(new Date());
        now.add(2, -3);
        if (dateformat == null || dateformat.trim().equals("")) {
            dateformat = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
        return dateFormat.format(now.getTime());
    }

    public static String getSeason(String currentDate, String dateformat) {
        if (dateformat == null || dateformat.trim().equals("")) {
            dateformat = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
        GregorianCalendar now = new GregorianCalendar();
        try {
            now.setTime(dateFormat.parse(currentDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        now.add(2, -3);
        return dateFormat.format(now.getTime());
    }

    public static String getMonth(String dateformat) {
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(new Date());
        now.add(2, -1);
        if (dateformat == null || dateformat.trim().equals("")) {
            dateformat = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
        return dateFormat.format(now.getTime());
    }

    public static int getRandom(int num) {
        Random r = new Random();
        return r.nextInt(num);
    }

    public static String getMonth(String currentDate, String dateformat) {
        if (dateformat == null || dateformat.trim().equals("")) {
            dateformat = DATE_FORMAT;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
        GregorianCalendar now = new GregorianCalendar();
        try {
            now.setTime(dateFormat.parse(currentDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        now.add(2, -1);
        return dateFormat.format(now.getTime());
    }

    public static void main(String[] args) {
        String a = "abc";
        System.out.println(a.length());
        System.out.println(MyDateUtil.getBeginOfMonth(new Date()));
    }

    public static Date getTime(String dateStr) {
        String x;
        Date sysDate = new Date();
        if (!MyStringUtil.hasValue(dateStr)) {
            return sysDate;
        }
        if (dateStr.indexOf("\u5185") >= 0) {
            dateStr = dateStr.replace("\u5185", "\u524d");
        }
        if (!(x = MyStringUtil.getRegexGroup("(^\\d+)\\s?\u5206\u949f\u524d$", dateStr, 1)).equals("")) {
            return MyDateUtil.getRelativeDate(sysDate, 12, -Integer.parseInt(x));
        }
        x = MyStringUtil.getRegexGroup("(^\\d+)\\s?\u5c0f\u65f6\u524d$", dateStr, 1);
        if (!x.equals("")) {
            return MyDateUtil.getRelativeDate(sysDate, 10, -Integer.parseInt(x));
        }
        x = MyStringUtil.getRegexGroup("(^\\d+)\\s?\u5929\u524d$", dateStr, 1);
        if (!x.equals("")) {
            return MyDateUtil.getRelativeDate(sysDate, 5, -Integer.parseInt(x));
        }
        return MyDateUtil.getDate(dateStr, DATE_FORMAT);
    }

    public static Date getBeginOfMonth(Date now) {
        Date result = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM");
        String tp = sdf2.format(now) + "-01 00:00:00";
        try {
            result = sdf.parse(tp);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date getBeginOfWeek(Date now, boolean mondayfirst) {
        Date result = new Date();
        int n = MyDateUtil.getDayInThisWeek(now);
        n = mondayfirst ? 0 - n : -1 - n;
        result = MyDateUtil.getRelativeDate(now, 5, n);
        String tempdate = MyDateUtil.getStr(result, DATE_FORMAT) + " 00:00:00";
        result = MyDateUtil.getDate(tempdate, DATE_TIME_FORMAT);
        return result;
    }

    public static Date getLastOfMonth(Date now) {
        int i;
        Date result = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf3 = new SimpleDateFormat("MM");
        SimpleDateFormat sdf4 = new SimpleDateFormat("yyyy");
        Integer month = new Integer(sdf3.format(now));
        Integer year = new Integer(sdf4.format(now));
        int lastday = 28;
        boolean flag = false;
        int[] odd = new int[]{1, 3, 5, 7, 8, 10, 12};
        int[] even = new int[]{4, 6, 9, 11};
        for (i = 0; i < odd.length; ++i) {
            if (!month.equals(odd[i])) continue;
            flag = true;
        }
        if (flag) {
            lastday = 31;
            flag = false;
        }
        for (i = 0; i < even.length; ++i) {
            if (!month.equals(even[i])) continue;
            flag = true;
        }
        if (flag) {
            lastday = 30;
            flag = false;
        }
        if (month.equals(2) && (year % 4 == 0 && year % 100 != 0 || year % 400 == 0)) {
            lastday = 29;
        }
        String tp = sdf2.format(now) + "-" + lastday + " 23:59:59";
        try {
            result = sdf.parse(tp);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date getLastOfWeek(Date now, boolean mondayfirst) {
        Date result = new Date();
        int n = MyDateUtil.getDayInThisWeek(now);
        n = mondayfirst ? 6 - n : 5 - n;
        result = MyDateUtil.getRelativeDate(now, 5, n);
        String tempdate = MyDateUtil.getStr(result, DATE_FORMAT) + " 23:59:59";
        result = MyDateUtil.getDate(tempdate, DATE_TIME_FORMAT);
        return result;
    }

    public static int getWeekOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weeks = calendar.get(3);
        return weeks;
    }
}

