/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.utils.httpclient.getweibocookie;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexPaserUtil {
    private String beginRegex;
    private String endRegex;
    private Matcher matcher;
    public static final String TEXTTEGEX = ".*?";
    public static final String W = "\\W*?";
    public static final String N = "";
    public static final String TEXTEGEXANDNRT = "[\\s\\S]*?";
    public static final String zel_all_chars = "[\\s\\S]*";
    private List<String> filterRegexList = new ArrayList<String>();
    public static String All_Chinese_Char = "[\\sA-Za-z\\d\\u4E00-\\u9FA5\\pP\\pZ\\pM\\pN\u3040-\u309f\u30a0-\u30ff+\\-*/\\\\$\u25cf=><|\\[\\]]";
    public Pattern All_Chinese_Char_Pattern = Pattern.compile(All_Chinese_Char);

    public boolean isAllChineseChar(String source) {
        char[] charArray;
        if (source == null || source.trim().length() == 0) {
            return true;
        }
        for (char c : charArray = source.toCharArray()) {
            if (this.All_Chinese_Char_Pattern.matcher(c + N).find()) continue;
            return false;
        }
        return true;
    }

    public RegexPaserUtil(String beginRegex, String endRegex, String content, String textRegex) {
        this.beginRegex = beginRegex;
        this.endRegex = endRegex;
        StringBuilder sb = new StringBuilder();
        sb.append(beginRegex);
        sb.append(textRegex);
        sb.append(endRegex);
        this.matcher = Pattern.compile(sb.toString()).matcher(content);
    }

    public RegexPaserUtil(String beginRegex, String textRegex, String endRegex, String content, String flag) {
        this.beginRegex = beginRegex;
        this.endRegex = endRegex;
        StringBuilder sb = new StringBuilder();
        sb.append(beginRegex);
        sb.append(textRegex);
        sb.append(endRegex);
        this.matcher = Pattern.compile(sb.toString()).matcher(content);
    }

    public RegexPaserUtil(String beginRegex, String endRegex, String textRegex) {
        this.beginRegex = beginRegex;
        this.endRegex = endRegex;
        StringBuilder sb = new StringBuilder();
        sb.append(beginRegex);
        sb.append(textRegex);
        sb.append(endRegex);
        this.matcher = Pattern.compile(sb.toString()).matcher(N);
    }

    public RegexPaserUtil(String beginRegex, String endRegex) {
        this.beginRegex = beginRegex;
        this.endRegex = endRegex;
        StringBuilder sb = new StringBuilder();
        sb.append(beginRegex);
        sb.append(TEXTTEGEX);
        sb.append(endRegex);
        this.matcher = Pattern.compile(sb.toString()).matcher(N);
    }

    public String getSimpleText() {
        if (this.matcher.find()) {
            String str = this.matcher.group().trim();
            return str;
        }
        return null;
    }

    public String getText() {
        if (this.matcher.find()) {
            String str = this.matcher.group().trim().replaceFirst(this.beginRegex, N).replaceAll(this.endRegex, N);
            Iterator<String> it = this.filterRegexList.iterator();
            while (it.hasNext()) {
                str = str.replaceAll(it.next(), N);
            }
            return str;
        }
        return null;
    }

    public String getLastText() {
        String str = null;
        while (this.matcher.find()) {
            str = this.matcher.group().trim().replaceFirst(this.beginRegex, N).replaceAll(this.endRegex, N);
        }
        return str;
    }

    public String getNext() {
        return this.matcher.group();
    }

    public String getNextTxt() {
        String str = this.matcher.group().trim().replaceFirst(this.beginRegex, N).replaceAll(this.endRegex, N);
        Iterator<String> it = this.filterRegexList.iterator();
        while (it.hasNext()) {
            str = str.replaceAll(it.next(), N);
        }
        return str;
    }

    public String getNextAddFilter() {
        String str = this.matcher.group();
        Iterator<String> it = this.filterRegexList.iterator();
        while (it.hasNext()) {
            str = str.replaceAll(it.next(), N);
        }
        return str;
    }

    public String getNextText() {
        String str = this.matcher.group();
        str = str.replaceFirst(this.beginRegex, N).replaceAll(this.endRegex, N);
        return str;
    }

    public boolean hasNext() {
        return this.matcher.find();
    }

    public RegexPaserUtil reset(String content) {
        this.matcher.reset(content);
        return this;
    }

    public RegexPaserUtil addFilterRegex(String filterRegex) {
        this.filterRegexList.add(filterRegex);
        return this;
    }

    public String getTextList() {
        String str = N;
        int count = 0;
        while (this.matcher.find()) {
            str = count == 0 ? this.matcher.group().trim().replaceFirst(this.beginRegex, N).replaceAll(this.endRegex, N) : str + "#" + this.matcher.group().trim().replaceFirst(this.beginRegex, N).replaceAll(this.endRegex, N);
            ++count;
        }
        return str;
    }

    public static void main(String[] args) {
        String source = "\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd  ";
        RegexPaserUtil regexPaserUtil = new RegexPaserUtil(null, null);
        System.out.println(regexPaserUtil.isAllChineseChar(source));
    }
}

