/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.utils.httpclient.getweibocookie;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import org.apache.log4j.Logger;

public class URLReader {
    private static Logger logger = Logger.getLogger(URLReader.class);

    public static void readAndSave(String url, String fileFullName) throws Exception {
        int read;
        System.out.println("Starting.");
        URL u = new URL(url);
        byte[] buffer = new byte[8192];
        int ava = 0;
        long start = System.currentTimeMillis();
        BufferedInputStream bin = new BufferedInputStream(u.openStream());
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(fileFullName));
        while ((read = bin.read(buffer)) > -1) {
            bout.write(buffer, 0, read);
            long speed = (long)(ava += read) / (System.currentTimeMillis() - start);
            System.out.println("Download: " + ava + " byte(s)" + "    avg speed: " + speed + "  (kb/s)");
        }
        bout.flush();
        bout.close();
        System.out.println("Done. size:" + ava + " byte(s)");
    }

    public static void download(String url, String fileFullName) {
        try {
            int read;
            logger.info((Object)("\u6b63\u5728\u4e0b\u8f7d---" + url));
            URL u = new URL(url);
            byte[] buffer = new byte[8192];
            File localFile = new File(fileFullName);
            localFile = localFile.getParentFile();
            if (localFile != null) {
                localFile.mkdirs();
            }
            BufferedInputStream bin = new BufferedInputStream(u.openStream());
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(fileFullName));
            while ((read = bin.read(buffer)) > -1) {
                bout.write(buffer, 0, read);
            }
            bout.flush();
            bout.close();
            logger.info((Object)("\u5b8c\u6210\u4e0b\u8f7d---" + url));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("\u4e0b\u8f7d\u9a8c\u8bc1\u7801\u56fe\u7247\u65f6\u51fa\u73b0\u9519\u8bef!" + e.getLocalizedMessage()));
        }
    }

    public static void main(String[] args) throws Exception {
        URLReader.readAndSave("http://www.gb168.cn/std/saleagent/dpdf.jsp?id=76602771-ff31-4c57-b683-93220d8c2a91", "d:/kk.pdf");
    }
}

