/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.visualTree.example;

import com.fuwenchao.visualTree.example.JTreeTransferable;
import com.fuwenchao.visualTree.example.VEachDir;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DocsTreeTransferHanlder
extends TransferHandler {
    private static final long serialVersionUID = 1910170308494195795L;

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        TreePath[] paths = tree.getSelectionPaths();
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        for (TreePath path : paths) {
            nodes.add((DefaultMutableTreeNode)path.getLastPathComponent());
        }
        return new JTreeTransferable(nodes);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(JTreeTransferable.FLAVOR) && support.getDropAction() == 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        System.out.println("ImportData");
        JTree tree = (JTree)support.getComponent();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        Transferable transfer = support.getTransferable();
        try {
            List nodes = (List)transfer.getTransferData(JTreeTransferable.FLAVOR);
            JTree.DropLocation location = (JTree.DropLocation)support.getDropLocation();
            DefaultMutableTreeNode newParent = (DefaultMutableTreeNode)location.getPath().getLastPathComponent();
            VEachDir eDir = (VEachDir)newParent.getUserObject();
            System.out.println("The drage after NewParent DirName:" + eDir.getDirName() + ",DirID:" + eDir.getDirId());
            for (DefaultMutableTreeNode node : nodes) {
                eDir = (VEachDir)node.getUserObject();
                System.out.println("Before Drag the Node DirName:" + eDir.getDirName());
                model.removeNodeFromParent(node);
                model.insertNodeInto(node, newParent, newParent.getChildCount());
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

