/*
 * Decompiled with CFR 0.152.
 */
package com.fuwenchao.zookeeper;

import com.fuwenchao.zookeeper.DataMonitor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class Executor
implements Watcher,
Runnable,
DataMonitor.DataMonitorListener {
    String znode;
    DataMonitor dm;
    ZooKeeper zk;
    String filename;
    String[] exec;
    Process child;

    public Executor(String hostPort, String znode, String filename, String[] exec) throws KeeperException, IOException {
        this.filename = filename;
        this.exec = exec;
        this.zk = new ZooKeeper(hostPort, 3000, (Watcher)this);
        this.dm = new DataMonitor(this.zk, znode, null, this);
    }

    public static void main(String[] args) {
        String hostPort = "192.168.61.129:2191";
        String znode = "/zk_test";
        String filename = "d:\\zk_test.txt";
        String[] exec = new String[1];
        try {
            new Executor(hostPort, znode, filename, exec).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void process(WatchedEvent event) {
        System.out.println("executor process!");
        this.dm.process(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Executor executor = this;
            synchronized (executor) {
                while (!this.dm.dead) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closing(int rc) {
        Executor executor = this;
        synchronized (executor) {
            this.notifyAll();
        }
    }

    @Override
    public void exists(byte[] data) {
        if (data == null) {
            if (this.child != null) {
                System.out.println("Killing process");
                this.child.destroy();
                try {
                    this.child.waitFor();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.child = null;
        } else {
            if (this.child != null) {
                System.out.println("Stopping child");
                this.child.destroy();
                try {
                    this.child.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(this.filename);
                fos.write(data);
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class StreamWriter
    extends Thread {
        OutputStream os;
        InputStream is;

        StreamWriter(InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
            this.start();
        }

        @Override
        public void run() {
            byte[] b = new byte[80];
            try {
                int rc;
                while ((rc = this.is.read(b)) > 0) {
                    this.os.write(b, 0, rc);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

