/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtil {
    private static Log log = LogFactory.getLog(DateUtil.class);
    private static String defaultDatePattern = null;
    private static String timePattern = "HH:mm";
    public static final String TS_FORMAT = DateUtil.getDatePattern() + " HH:mm:ss.S";
    private static Calendar cale = Calendar.getInstance();
    private static SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
    private static SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat sdfTable = new SimpleDateFormat("yyyyMM");

    public static String getDateTime() {
        try {
            return datetime.format(Calendar.getInstance().getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDateTime():" + e.getMessage()));
            return "";
        }
    }

    public static String getDateTime(int minute) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.set(12, minute);
            return datetime.format(cal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDateTime():" + e.getMessage()));
            return "";
        }
    }

    public static String getDateTime(int hour, int minute, int second) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            return datetime.format(cal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDateTime():" + e.getMessage()));
            return "";
        }
    }

    public static String getbeforeDateTime(int hour, int minute, int second, boolean beforeday) {
        try {
            Calendar cal = Calendar.getInstance();
            if (beforeday) {
                int day = cal.get(5);
                cal.set(5, day - 1);
            }
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            return datetime.format(cal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDateTime():" + e.getMessage()));
            return "";
        }
    }

    public static String getDateTime(long date) {
        try {
            return datetime.format(new Date(date));
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDateTime():" + e.getMessage()));
            return "";
        }
    }

    public static String getDate() {
        try {
            return date.format(cale.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDate():" + e.getMessage()));
            return "";
        }
    }

    public static String getsdfTable() {
        try {
            return sdfTable.format(Calendar.getInstance().getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDate():" + e.getMessage()));
            return "";
        }
    }

    public static String getsdfTable(String datatime) {
        try {
            Date date = DateUtil.convertStringToDate(datatime);
            return sdfTable.format(date);
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDate():" + e.getMessage()));
            return "";
        }
    }

    public static String getTime() {
        String temp = "";
        try {
            temp = temp + time.format(cale.getTime());
            return temp;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getTime():" + e.getMessage()));
            return "";
        }
    }

    public static int getHour() {
        int temp = 0;
        try {
            temp = Calendar.getInstance().get(11);
            return temp;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getTime():" + e.getMessage()));
            return 0;
        }
    }

    public static int getMinute() {
        int temp = 0;
        try {
            temp = Calendar.getInstance().get(12);
            return temp;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getTime():" + e.getMessage()));
            return 0;
        }
    }

    public static String getStartDate() {
        try {
            return DateUtil.getYear() + "-01-01";
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getStartDate():" + e.getMessage()));
            return "";
        }
    }

    public static String getEndDate() {
        try {
            return DateUtil.getDate();
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getEndDate():" + e.getMessage()));
            return "";
        }
    }

    public static String getYear() {
        try {
            return String.valueOf(cale.get(1));
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getYear():" + e.getMessage()));
            return "";
        }
    }

    public static String getMonth() {
        try {
            DecimalFormat df = new DecimalFormat();
            df.applyPattern("00");
            return df.format(cale.get(2) + 1);
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMonth():" + e.getMessage()));
            return "";
        }
    }

    public static int getDay() {
        int temp = 0;
        try {
            temp = Calendar.getInstance().get(5);
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDay():" + e.getMessage()));
        }
        return temp;
    }

    public static int getyesterday() {
        int temp = 0;
        try {
            Calendar cal = Calendar.getInstance();
            int day = cal.get(5);
            cal.set(5, day - 1);
            System.out.println(cal.getTime());
            temp = cal.get(5);
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDay():" + e.getMessage()));
        }
        return temp;
    }

    public static int getDays(String date1, String date2) {
        try {
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = date.parse(date1, pos);
            Date dt2 = date.parse(date2, pos1);
            long l = dt1.getTime() - dt2.getTime();
            int margin = (int)(l / 86400000L);
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getDays():" + e.toString()));
            return 0;
        }
    }

    public static int getHours(String date1, String date2) {
        try {
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = datetime.parse(date1, pos);
            Date dt2 = datetime.parse(date2, pos1);
            long l = dt1.getTime() - dt2.getTime();
            int margin = Math.abs((int)(l / 3600000L));
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getHours():" + e.toString()));
            return 0;
        }
    }

    public static int getMinutes(String date1, String date2) {
        try {
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = datetime.parse(date1, pos);
            Date dt2 = datetime.parse(date2, pos1);
            long l = dt1.getTime() - dt2.getTime();
            int margin = Math.abs((int)(l / 60000L));
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMinutes():" + e.toString()));
            return 0;
        }
    }

    public static int getSeconds(String date1, String date2) {
        try {
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = datetime.parse(date1, pos);
            Date dt2 = datetime.parse(date2, pos1);
            long l = dt1.getTime() - dt2.getTime();
            int margin = Math.abs((int)(l / 1000L));
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getSeconds():" + e.toString()));
            return 0;
        }
    }

    public static double getDoubledays(String date1, String date2) {
        try {
            ParsePosition pos = new ParsePosition(0);
            ParsePosition pos1 = new ParsePosition(0);
            Date dt1 = datetime.parse(date1, pos);
            Date dt2 = datetime.parse(date2, pos1);
            long l = dt1.getTime() - dt2.getTime();
            double margin = (double)l / 8.64E7;
            return margin;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMargin():" + e.toString()));
            return 0.0;
        }
    }

    public static int getMonthMargin(String date1, String date2) {
        try {
            int margin = (Integer.parseInt(date2.substring(0, 4)) - Integer.parseInt(date1.substring(0, 4))) * 12;
            return margin += Integer.parseInt(date2.substring(4, 7).replaceAll("-0", "-")) - Integer.parseInt(date1.substring(4, 7).replaceAll("-0", "-"));
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMargin():" + e.toString()));
            return 0;
        }
    }

    public static String addDay(String fromdate, int i) {
        try {
            GregorianCalendar gCal = new GregorianCalendar(Integer.parseInt(fromdate.substring(0, 4)), Integer.parseInt(fromdate.substring(5, 7)) - 1, Integer.parseInt(fromdate.substring(8, 10)));
            gCal.add(5, i);
            return date.format(gCal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.addDay():" + e.toString()));
            return DateUtil.getDate();
        }
    }

    public static String addMonth(String fromdate, int i) {
        try {
            GregorianCalendar gCal = new GregorianCalendar(Integer.parseInt(fromdate.substring(0, 4)), Integer.parseInt(fromdate.substring(5, 7)) - 1, Integer.parseInt(fromdate.substring(8, 10)));
            gCal.add(2, i);
            return date.format(gCal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.addMonth():" + e.toString()));
            return DateUtil.getDate();
        }
    }

    public static String addYear(String fromdate, int i) {
        try {
            GregorianCalendar gCal = new GregorianCalendar(Integer.parseInt(fromdate.substring(0, 4)), Integer.parseInt(fromdate.substring(5, 7)) - 1, Integer.parseInt(fromdate.substring(8, 10)));
            gCal.add(1, i);
            return date.format(gCal.getTime());
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.addYear():" + e.toString()));
            return "";
        }
    }

    public static int getMaxDay(String year, String month) {
        int day = 0;
        try {
            int iyear = Integer.parseInt(year);
            int imonth = Integer.parseInt(month);
            day = imonth == 1 || imonth == 3 || imonth == 5 || imonth == 7 || imonth == 8 || imonth == 10 || imonth == 12 ? 31 : (imonth == 4 || imonth == 6 || imonth == 9 || imonth == 11 ? 30 : (0 == iyear % 4 && 0 != iyear % 100 || 0 == iyear % 400 ? 29 : 28));
            return day;
        }
        catch (Exception e) {
            log.debug((Object)("DateUtil.getMonthDay():" + e.toString()));
            return 1;
        }
    }

    public String rollDate(String orgDate, int Type2, int Span) {
        try {
            int iday;
            int imonth;
            int iyear;
            String temp = "";
            int iPos = 0;
            int seperater = 45;
            if (orgDate == null || orgDate.length() < 6) {
                return "";
            }
            iPos = orgDate.indexOf(seperater);
            if (iPos > 0) {
                iyear = Integer.parseInt(orgDate.substring(0, iPos));
                temp = orgDate.substring(iPos + 1);
            } else {
                iyear = Integer.parseInt(orgDate.substring(0, 4));
                temp = orgDate.substring(4);
            }
            iPos = temp.indexOf(seperater);
            if (iPos > 0) {
                imonth = Integer.parseInt(temp.substring(0, iPos));
                temp = temp.substring(iPos + 1);
            } else {
                imonth = Integer.parseInt(temp.substring(0, 2));
                temp = temp.substring(2);
            }
            if (--imonth < 0 || imonth > 11) {
                imonth = 0;
            }
            if ((iday = Integer.parseInt(temp)) < 1 || iday > 31) {
                iday = 1;
            }
            Calendar orgcale = Calendar.getInstance();
            orgcale.set(iyear, imonth, iday);
            temp = DateUtil.rollDate(orgcale, Type2, Span);
            return temp;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String rollDate(Calendar cal, int Type2, int Span) {
        try {
            String temp = "";
            Calendar rolcale = cal;
            rolcale.add(Type2, Span);
            temp = date.format(rolcale.getTime());
            return temp;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static synchronized String getDatePattern() {
        defaultDatePattern = "yyyy-MM-dd";
        return defaultDatePattern;
    }

    public static final String getDate(Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate != null) {
            df = new SimpleDateFormat(DateUtil.getDatePattern());
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static String getTimeNow(Date theTime) {
        return DateUtil.getDateTime(timePattern, theTime);
    }

    public Calendar getToday() throws ParseException {
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DateUtil.getDatePattern());
        String todayAsString = df.format(today);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.convertStringToDate(todayAsString));
        return cal;
    }

    public static final String getDateTime(String aMask, Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate == null) {
            log.error((Object)"aDate is null!");
        } else {
            df = new SimpleDateFormat(aMask);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static final String convertDateToString(Date aDate) {
        return DateUtil.getDateTime(DateUtil.getDatePattern(), aDate);
    }

    public static final Date convertStringToDate(String aMask, String strDate) throws ParseException {
        SimpleDateFormat df = null;
        Date date = null;
        df = new SimpleDateFormat(aMask);
        if (log.isDebugEnabled()) {
            log.debug((Object)("converting '" + strDate + "' to date with mask '" + aMask + "'"));
        }
        try {
            date = df.parse(strDate);
        }
        catch (ParseException pe) {
            log.error((Object)("ParseException: " + pe));
            throw pe;
        }
        return date;
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        Date aDate = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("converting date with pattern: " + DateUtil.getDatePattern()));
            }
            aDate = DateUtil.convertStringToDate(DateUtil.getDatePattern(), strDate);
        }
        catch (ParseException pe) {
            log.error((Object)("Could not convert '" + strDate + "' to a date, throwing exception"));
            throw new ParseException(pe.getMessage(), pe.getErrorOffset());
        }
        return aDate;
    }

    public static String getSimpleDateFormat() {
        SimpleDateFormat formatter = new SimpleDateFormat();
        String NDateTime = formatter.format(new Date());
        return NDateTime;
    }

    public static boolean compareTo(String last, String now) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date temp1 = formatter.parse(last);
            Date temp2 = formatter.parse(now);
            if (temp1.after(temp2)) {
                return false;
            }
            if (temp1.before(temp2)) {
                return true;
            }
        }
        catch (ParseException e) {
            log.debug((Object)e.getMessage());
        }
        return false;
    }

    public static Date addStartTime(Date param) {
        Date date = param;
        try {
            date.setHours(0);
            date.setMinutes(0);
            date.setSeconds(0);
            return date;
        }
        catch (Exception ex) {
            return date;
        }
    }

    public static Date addEndTime(Date param) {
        Date date = param;
        try {
            date.setHours(23);
            date.setMinutes(59);
            date.setSeconds(0);
            return date;
        }
        catch (Exception ex) {
            return date;
        }
    }

    public static String getMonthLastDay(int month) {
        Date date = new Date();
        int[][] day = new int[][]{{0, 30, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
        int year = date.getYear() + 1900;
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return day[1][month] + "";
        }
        return day[0][month] + "";
    }

    public static String getMonthLastDay(int year, int month) {
        int[][] day = new int[][]{{0, 30, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return day[1][month] + "";
        }
        return day[0][month] + "";
    }

    public static String getTimestamp() {
        Date date = new Date();
        String timestamp = "" + (date.getYear() + 1900) + date.getMonth() + date.getDate() + date.getMinutes() + date.getSeconds() + date.getTime();
        return timestamp;
    }

    public static String getTimestamp(Date date) {
        String timestamp = "" + (date.getYear() + 1900) + date.getMonth() + date.getDate() + date.getMinutes() + date.getSeconds() + date.getTime();
        return timestamp;
    }

    public static Date getDate(String time) {
        Date date = new Date();
        try {
            SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = datetime.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static long getTimeMillis(String datetime) {
        long timemillis = 0L;
        Calendar cal = Calendar.getInstance();
        Date date = DateUtil.getDate(datetime);
        cal.setTime(date);
        timemillis = cal.getTimeInMillis();
        return timemillis;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getDateTime(-60));
        System.out.println(DateUtil.compareTo(DateUtil.getDateTime(-70), DateUtil.getDateTime(-60)));
        System.out.println(DateUtil.getDateTime(0));
        System.out.println(DateUtil.getsdfTable("2010-05-02"));
        System.out.println(DateUtil.getsdfTable("2010-05-04 23:22:11"));
        System.out.println(DateUtil.getsdfTable("2010-07-04 23:22:11"));
        System.out.println(DateUtil.getsdfTable("2010-06-01 23:22:11"));
        System.out.println(DateUtil.getyesterday());
        System.out.println(DateUtil.getsdfTable());
        System.out.println(DateUtil.getDateTime(0, 0, 0));
        System.out.println(DateUtil.getDateTime(23, 59, 59));
        System.out.println(DateUtil.getHour());
        System.out.println(DateUtil.getDateTime(System.currentTimeMillis()));
        System.out.println(DateUtil.getDate());
        System.out.println(DateUtil.getDateTime());
        System.out.println(DateUtil.getTime());
        System.out.println(DateUtil.getYear());
        System.out.println(DateUtil.getMonth());
        System.out.println(DateUtil.getStartDate());
        System.out.println(DateUtil.getEndDate());
        System.out.println("**" + DateUtil.getDay());
        System.out.println(DateUtil.getDays("2010-05-02", "2010-04-01"));
        System.out.println(DateUtil.getDoubledays("2010-05-07 23:22:11", "2010-04-01 01:33:33"));
        System.out.println(DateUtil.getSeconds("2012-09-04 16:49:59", "2012-09-04 16:47:02"));
        System.out.println(DateUtil.getDays("2010-05-02", "2010-05-01"));
    }
}

