/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import com.bfd.crawler.utils.EncodeUtil;
import com.bfd.crawler.utils.JsonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static String readFromFile2Str(String filename) {
        byte[] bytes = FileUtil.readFromFile(filename);
        String encode = EncodeUtil.getHtmlEncode(bytes);
        try {
            return new String(bytes, encode);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> readFromFile2StrSplitByLine(String filename) {
        byte[] bytes = FileUtil.readFromFile(filename);
        String encode = EncodeUtil.getHtmlEncode(bytes);
        String content = "";
        ArrayList<String> rs = new ArrayList<String>();
        try {
            content = new String(bytes, encode);
            for (String temp : content.split(System.getProperty("line.separator"))) {
                rs.add(temp);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static byte[] readFromFile(String filename) {
        File file = new File(filename);
        byte[] bytes = new byte[(int)file.length()];
        try {
            FileInputStream fis = new FileInputStream(file);
            fis.read(bytes);
            return bytes;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void appendToFile(String filename, String data) {
        FileUtil.writeToFile(filename, data.getBytes(), true);
    }

    public static void writeToFile(String filename, String data) {
        FileUtil.writeToFile(filename, data.getBytes(), false);
    }

    public static void writeToFile(String filename, byte[] data, boolean append) {
        File file = new File(filename);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(file, append);
            fos.write(data);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void appendMethod(String fileName, String content) {
        try {
            FileWriter writer = new FileWriter(fileName, true);
            writer.write(content + "\r\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main2(String[] args) {
        String fileName = "d:\\openhuburl.txt";
        List<String> content = FileUtil.readFromFile2StrSplitByLine(fileName);
        System.out.println(JsonUtils.toJSONString(content));
    }

    public static List getListFiles(String path, String suffix, boolean isdepth) {
        File file = new File(path);
        ArrayList<String> fileList = new ArrayList<String>();
        return FileUtil.listFile(file, suffix, isdepth, fileList);
    }

    public static List listFile(File f, String suffix, boolean isdepth, List<String> fileList) {
        if (f.isDirectory() && isdepth) {
            File[] t = f.listFiles();
            for (int i = 0; i < t.length; ++i) {
                FileUtil.listFile(t[i], suffix, isdepth, fileList);
            }
        } else {
            String filePath = f.getAbsolutePath();
            if (suffix != null) {
                int begIndex = filePath.lastIndexOf(".");
                String tempsuffix = "";
                if (begIndex != -1) {
                    tempsuffix = filePath.substring(begIndex + 1, filePath.length());
                }
                if (tempsuffix.equals(suffix)) {
                    fileList.add(filePath);
                }
            } else {
                fileList.add(filePath);
            }
        }
        return fileList;
    }

    public static long getFileSize(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return 0L;
        }
        return file.length();
    }

    public static void main(String[] args) {
        String str = "https://www.openhub.net/p/acetaociao";
        System.out.println(str.getBytes().length);
    }
}

