/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils;

import com.bfd.crawler.tmptask.Task;
import com.bfd.crawler.utils.JacksonUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonUtils {
    private static final Log log = LogFactory.getLog(JsonUtils.class);
    private static JsonFactory _jsonFactory = null;

    public static String toJSONString(Object object) {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        try {
            return om.writeValueAsString(object);
        }
        catch (Exception e) {
            log.warn((Object)"to json string exception, will use fastjson to parse", (Throwable)e);
            return null;
        }
    }

    public static Map parseObject(String str) throws Exception {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        return (Map)om.readValue(str.getBytes(), Object.class);
    }

    public static Object parseToObject(String str) throws Exception {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        return om.readValue(str.getBytes(), Object.class);
    }

    public static List parseArray(String str) throws Exception {
        ObjectMapper om = new ObjectMapper(_jsonFactory);
        return (List)om.readValue(str.getBytes(), Object.class);
    }

    public static void main(String[] args) {
        Task task = new Task();
        task.setCid("ctest");
        task.setUrl("http://www.baidu.com");
        String taskStr = JsonUtils.toJSONString(task);
        try {
            Task task2 = JacksonUtils.extractObject(taskStr, Task.class);
            System.out.println(task2.getUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (_jsonFactory == null) {
            _jsonFactory = new JsonFactory();
            _jsonFactory.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
            _jsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        }
    }
}

