/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils.kafka.writer;

import com.bfd.crawler.utils.ConfigUtils;
import java.io.File;
import java.util.List;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.javaapi.producer.ProducerData;
import kafka.producer.ProducerConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KfkProducer {
    private static final Log LOG = LogFactory.getLog(KfkProducer.class);
    private Producer<String, String> producter = null;
    private Properties props;
    private String name;
    private static KfkProducer kfkProducer;
    public static String topic;

    public static synchronized KfkProducer getInstance() {
        if (kfkProducer == null) {
            kfkProducer = new KfkProducer("P1");
        }
        return kfkProducer;
    }

    private KfkProducer(String name) {
        ConfigUtils.getInstance().readFile(new File("../etc/write2kfk-config.properties"));
        this.props = KfkProducer.loadPropties(name);
        this.name = name;
        ProducerConfig config = new ProducerConfig(this.props);
        this.producter = new Producer(config);
        LOG.info((Object)("Connected zk successfully, zk=" + ConfigUtils.getInstance().getProp("zkConnect")));
    }

    private static Properties loadPropties(String name) {
        Properties props = new Properties();
        String connect = ConfigUtils.getInstance().getProp(name + ".zkConnect", "192.168.50.11:2191,192.168.50.12:2191,192.168.50.13:2191,192.168.50.14:2191,192.168.50.15:2191/kafka07");
        if (StringUtils.isEmpty((String)connect)) {
            System.out.println("error no zkpath");
        }
        LOG.info((Object)("zk path:" + connect));
        props.put("zk.connect", connect);
        props.put("serializer.class", ConfigUtils.getInstance().getProp(name + ".kafka.serializer", "kafka.serializer.StringEncoder"));
        props.put("zk.sessiontimeout.ms", ConfigUtils.getInstance().getProp(name + ".zk.sessiontimeout.ms", "50000"));
        props.put("connect.timeout.ms", ConfigUtils.getInstance().getProp(name + ".connectionTimeOut", "50000"));
        props.put("zk.connectiontimeout.ms", ConfigUtils.getInstance().getProp(name + ".zk.connectiontimeout.ms", "50000"));
        return props;
    }

    public boolean send(String message, String topic) {
        while (this.producter == null) {
            ProducerConfig config = new ProducerConfig(this.props);
            this.producter = new Producer(config);
        }
        if (StringUtils.isEmpty((String)topic) || StringUtils.isEmpty((String)message)) {
            LOG.warn((Object)"before send msg get topic or message -> null, ");
            return false;
        }
        ProducerData producerData = new ProducerData(topic, (Object)message);
        try {
            this.producter.send(producerData);
            LOG.debug((Object)("sended message to topic -> " + topic));
        }
        catch (Exception e) {
            LOG.warn((Object)"send data exception, err=", (Throwable)e);
            this.close();
            return false;
        }
        return true;
    }

    public boolean send(String topic, List<String> messages) {
        if (messages == null || messages.size() == 0) {
            LOG.warn((Object)"before send msg get topic or message -> null, projName=");
            return false;
        }
        ProducerData producerData = new ProducerData(topic, messages);
        try {
            this.producter.send(producerData);
        }
        catch (Exception e) {
            LOG.warn((Object)(Thread.currentThread().getName() + ":topic is " + topic + ".message size is " + messages.size() + ".send data exception, err="), (Throwable)e);
            this.close();
            ProducerConfig config = new ProducerConfig(this.props);
            this.producter = new Producer(config);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.producter != null) {
            try {
                this.producter.close();
            }
            catch (Exception e) {
                LOG.warn((Object)"close producter exception, err=", (Throwable)e);
            }
            finally {
                this.producter = null;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        KfkProducer kp = new KfkProducer("p1");
    }

    static {
        topic = "poc_allnews";
    }
}

