/*
 * Decompiled with CFR 0.152.
 */
package com.bfd.crawler.utils.templateparser;

import com.bfd.crawler.utils.JsonUtils;
import com.bfd.crawler.utils.TextUtil;
import com.bfd.crawler.utils.templateparser.DomCFGTree;
import com.bfd.crawler.utils.templateparser.DomTemplate;
import com.bfd.crawler.utils.templateparser.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.w3c.dom.DocumentFragment;

public class DomConfig {
    private static final Log log = LogFactory.getLog(DomConfig.class);
    private static final String CONFIG_NAME = "dom_config";
    private static volatile DomConfig instance;
    private Map<String, DomTemplate> siteTmpls = new ConcurrentHashMap<String, DomTemplate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomConfig getInstance() {
        if (instance != null) return instance;
        Class<DomConfig> clazz = DomConfig.class;
        synchronized (DomConfig.class) {
            if (instance != null) return instance;
            instance = new DomConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected DomConfig() {
    }

    public boolean hasTemplate(String sitename) {
        return this.siteTmpls.containsKey(sitename);
    }

    public static void main3(String[] args) {
        PropertyConfigurator.configure((String)"/home/ian/dev/parser/log4j.properties");
        DomTemplate tpl = DomConfig.getInstance().getByBizid("Cdida");
        log.info((Object)tpl);
        log.info((Object)"ok");
    }

    public DomCFGTree readBuziConfig(Template template) {
        String XMLhead = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        StringBuilder sbBuilder = new StringBuilder();
        String tmpl = template.getTmpl();
        sbBuilder.append(XMLhead);
        sbBuilder.append(tmpl);
        DocumentFragment doc = TextUtil.parse2Xml(sbBuilder.toString(), "utf8");
        return new DomCFGTree(doc.getFirstChild(), template);
    }

    public static void main(String[] args) {
        String xml = "<tmpl path='div@@searchwrap w980@4'><fld name='category' path='div@@searchCrumb@2' multi='' ext=''/><block path='div@@itemSearchResult @*/ul@@@0/li@@producteg@*' name='items'><fld name='imgurl' path='a@@@0/img@@@0' multi='' ext=''/><fld name='itemlink' path='a@@title@1' multi='' ext='' link='true' linkType='item'/><fld name='price' path='p@@price@0/strong@@@0' multi='' ext=''/><block path='div@@test@*' name='tests'><fld name='test' path='p@@@0' multi='' ext=''></block></block></tmpl>";
        Template t = new Template();
        t.setOutput("category,items");
        t.setRequired("items");
        DomTemplate domTemplate = new DomTemplate(t);
        System.out.println("=========" + JsonUtils.toJSONString(domTemplate.getTemplates().get(0).getTreePath()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("=========" + domTemplate.getTemplates().get(0).getTreePath()));
        }
    }

    public DomTemplate getByBizid(String bid) {
        return this.get(bid);
    }

    public DomTemplate get(String bid) {
        if (this.siteTmpls.containsKey(bid)) {
            return this.siteTmpls.get(bid);
        }
        return null;
    }

    public void getWithRequest(String bid, String type) {
    }

    public List<DomCFGTree> get(String bid, String type) {
        DomTemplate domTemplate = this.get(bid);
        ArrayList<DomCFGTree> templates = new ArrayList<DomCFGTree>();
        if (domTemplate != null) {
            templates = domTemplate.getTemplates();
            for (DomCFGTree tree : templates) {
                if (!tree.getType().equals(type)) continue;
                templates.add(tree);
            }
        }
        return templates;
    }
}

